/*------------------------------------------------------------------------------*
 * File Name: XYZ2MatDlg.h	 													*
 * Creation: Sim 02-27-2009														*
 * Purpose: OriginC Header H file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef XYZ2MATDLG_H
#define XYZ2MATDLG_H

#define WM_USER_XYZ2MAT_DLG_OFFSET (WM_USER + 1201)
enum
{
	WM_USER_XYZ2MAT_DLG_MOVE_RESTRICTION_LINE = WM_USER_XYZ2MAT_DLG_OFFSET,
	//WM_USER_XYZ2MAT_DLG_MOVE_RESTRICTION_RECT,
};

//////////////////////////////////////////////////////////////////////////////////////////////////
class XYZ2MatDlg : public DynaDlg
{
public:
	///Sophy 9/6/2010 ORG-849 SUPPORT_PLOT_XYZ_FROM_WORKSHEET_WITH_GRIDDING
	//XYZ2MatDlg();
	XYZ2MatDlg(LPCSTR lpcszDlgName);
	///end SUPPORT_PLOT_XYZ_FROM_WORKSHEET_WITH_GRIDDING
	
public:
	int		DoModalEx(TreeNode& trGetN, HWND hParent = NULL);
	//int Create(HWND hParent = NULL);	//for development, way to check result
	void	UpdateEditTreeNode(TreeNode& trGetN);
	
protected:
	///----------------- Message Map ----------------
	EVENTS_BEGIN
		ON_GETNDLG_MSGS(IDC_XYZ_SETTINGS_DYNA_GRID)
		
		ON_INIT(OnInitDialog)
		ON_READY(OnReady)
		ON_DESTROY(OnDestroy)
		ON_SIZE(OnDlgResize)

		ON_SYSCOMMAND(OnSystemCommand)
		
		ON_CBN_SELCHANGE(IDC_THEME_COMB, OnComboChangeTheme)
		ON_BN_CLICKED(IDC_SAVE_AS_BTN, OnSaveThemeAs)

		// must add, for show error message etc.
		ON_USER_MSG(WM_USER_MSG_ON_DLG, OnDynamicMsg)	///Joseph 05/18/07	ADD_OPERATION_ERRMSG_LINE
		
		ON_USER_MSG(WM_USER_ON_GRAPH_OBJECT_CHANGE, InvokeGlobalEventOnGraphObjectChange)
		
		ON_BN_CLICKED(IDC_XYZ_SHOW_GRAPH, OnShowBottomPane)
		ON_BN_CLICKED(IDC_XYZ_QUICK_PREVIEW_CHK, OnChangePreviewMode)
		ON_TAB_SEL_CHANGE(IDC_XYZ_GRAPH_TAB, OnTabChange)

		ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnAfterValueChange)
		//ON_USER_MSG(WM_USER_ON_MOVE_RECT, OnMoveRect)/// Iris 12/06/2006 v8.0519 UPDATE_MAT_XY_RANGE_BY_DRAG_RECT
		ON_USER_MSG(WM_USER_XYZ2MAT_DLG_MOVE_RESTRICTION_LINE, OnMoveLine)

		ON_INIT_SIZE(OnInitSize)
		ON_RESTORESIZE(OnRestoreSize)
		ON_GETMINMAXINFO(OnMinMaxInfo)
		
		ON_HELPINFO(OnHelp)

	EVENTS_END
	///----------------------------------------------

	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		nHelpID = IDD_XF_XYZ2Mat;
		return true;
	}

	BOOL OnInitDialog();
	BOOL OnReady();
	BOOL OnDestroy();
	BOOL OnDlgResize(int nType, int cx, int cy);

	BOOL OnShowBottomPane(Control ctrl);
	BOOL OnChangePreviewMode(Control ctrl);
	BOOL OnTabChange(Control ctrl);
	
	void OnAfterValueChange(int nRow, int nCol);
	void OnMoveLine(int nRow, int nCol);
	//void OnMoveRect(int nRow, int nCol);/// Iris 12/06/2006 v8.0519 UPDATE_MAT_XY_RANGE_BY_DRAG_RECT

	virtual void OnEnableButtons(DWORD dwEnable, int nEvnetID = GETNE_ON_INIT);

	virtual void InvokeGlobalEventOnInitDialog();
	virtual void InvokeGlobalEventOnThemeChange();
	
	virtual void ResizeDlgControls()
	{
		OnDlgResize(0, GetDlgExtent(false), GetDlgExtent(true));
	}

	BOOL OnRestoreSize(DWORD dwSizeInfo);
	BOOL OnInitSize(int &left, int &top, int &right, int  &bottom);
	int	GetTotalHeight(bool bMin = false);
	int	GetTotalWidth(bool bMin = false);

	//virtual BOOL LoadTheme(TreeNode& trGetN, LPCSTR lpcszThemeName);
	
protected:
	void	SetDialogTitle(LPCSTR lpcszTitle);
	
protected:
	bool	SetInput();
	
	void	InitPreviewGraphs();
	bool	UpdatePreviewDatas();
	bool	UpdatePreviewGraphs();
	
	void	OnChange(int nType = XYZ_CHANGE_INIT);

private:
	bool 	getInputRange(XYZRange& dr);
	
	uint	getTabGraphContrlID(int nGraph);
	void 	getTabRect(RECT& rTab);
	
	void 	resizeTopPaneControl();
	
	PEVENT_GETN		getEventFunction();
protected:
	XYZGridding					m_XYZGridding;
	XYZ2MatGraphControlManager	m_GPCManager;
	string						m_strDlgName;	///Sophy 9/6/2010 ORG-849 SUPPORT_PLOT_XYZ_FROM_WORKSHEET_WITH_GRIDDING
	ComboBox					m_comboTheme;
	BitmapRadioButton			m_btnSaveTheme;
	Control						m_txtStatus;	
};

#endif //XYZ2MATDLG_H
